/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedIterable;
import java.util.Comparator;
import java.util.SortedSet;

@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements2) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements2);
        if (elements2 instanceof SortedSet) {
            comparator2 = SortedIterables.comparator((SortedSet)elements2);
        } else if (elements2 instanceof SortedIterable) {
            comparator2 = ((SortedIterable)elements2).comparator();
        } else {
            return false;
        }
        return comparator.equals(comparator2);
    }

    public static <E> Comparator<? super E> comparator(SortedSet<E> sortedSet) {
        Comparator<E> result2 = sortedSet.comparator();
        if (result2 == null) {
            result2 = Ordering.natural();
        }
        return result2;
    }
}

